/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.canvas.simulation;

import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.canvas.resources.VWResource;
import filenet.vw.toolkit.design.canvas.simulation.VWScenarioCanvasPanel;
import filenet.vw.toolkit.design.canvas.simulation.VWScenarioMenuHelper;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.IVWToolbarActionListener;
import filenet.vw.toolkit.utils.event.VWToolbarActionEvent;
import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class VWScenarioActionMenu
implements ActionListener,
IVWToolbarActionListener {
    private JMenuItem m_validateScenarioItem = null;
    private JMenuItem m_launchScenarioItem = null;
    private JMenuItem m_copyScenarioItem = null;
    private JMenuItem m_removeScenarioItem = null;
    private JMenuItem m_saveScenarioToLocaItem = null;
    private JMenuItem m_saveScenarioToRepositoryItem = null;
    private VWScenarioCanvasPanel m_scenarioCanvasPanel = null;
    private VWScenarioMenuHelper m_scenarioMenuHelper = null;

    public VWScenarioActionMenu(VWScenarioCanvasPanel scenarioCanvasPanel) {
        this.m_scenarioCanvasPanel = scenarioCanvasPanel;
        this.m_scenarioMenuHelper = this.m_scenarioCanvasPanel.getDesignerCoreData().getScenarioMenuHelper();
        this.m_scenarioCanvasPanel.getPropertyData().getToolbarActionNotifier().addToolbarActionListener(this);
    }

    public void releaseReferences() {
        this.m_validateScenarioItem = null;
        this.m_launchScenarioItem = null;
        this.m_copyScenarioItem = null;
        this.m_removeScenarioItem = null;
        this.m_saveScenarioToLocaItem = null;
        this.m_saveScenarioToRepositoryItem = null;
        this.m_scenarioCanvasPanel = null;
        this.m_scenarioMenuHelper = null;
    }

    public void actionPerformed(ActionEvent event) {
        try {
            VWSIMPropertyData propertyData = this.m_scenarioCanvasPanel.getPropertyData();
            if (event.getSource().equals(this.m_validateScenarioItem)) {
                this.m_scenarioMenuHelper.validateScenario(propertyData);
            } else if (event.getSource().equals(this.m_launchScenarioItem)) {
                this.m_scenarioMenuHelper.launchScenario(propertyData);
            } else if (event.getSource().equals(this.m_copyScenarioItem)) {
                this.m_scenarioMenuHelper.copyScenario(propertyData);
            } else if (event.getSource().equals(this.m_removeScenarioItem)) {
                this.m_scenarioMenuHelper.removeScenario(propertyData.getScenarioDefinition().getName());
            } else if (event.getSource().equals(this.m_saveScenarioToLocaItem)) {
                this.m_scenarioMenuHelper.saveScenarioToLocal(propertyData);
            } else if (event.getSource().equals(this.m_saveScenarioToRepositoryItem)) {
                this.m_scenarioMenuHelper.performFileNETAddNewItemAction(propertyData);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void toolbarActionPerformed(VWToolbarActionEvent event) {
        switch (event.getID()) {
            case 652: {
                this.performValidateSelectedItemAction();
            }
        }
    }

    protected void initializeMenu(JMenu actionMenu) {
        this.m_validateScenarioItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuValidateScenario_withHK);
        if (this.m_validateScenarioItem != null) {
            this.m_validateScenarioItem.addActionListener(this);
            actionMenu.add(this.m_validateScenarioItem);
        }
        this.m_launchScenarioItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuLaunchScenario_withHK);
        if (this.m_launchScenarioItem != null) {
            this.m_launchScenarioItem.addActionListener(this);
            actionMenu.add(this.m_launchScenarioItem);
        }
        actionMenu.addSeparator();
        this.m_copyScenarioItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuCopyScenario_withHK);
        if (this.m_copyScenarioItem != null) {
            this.m_copyScenarioItem.addActionListener(this);
            actionMenu.add(this.m_copyScenarioItem);
        }
        this.m_removeScenarioItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuRemoveScenario_withHK);
        if (this.m_removeScenarioItem != null) {
            this.m_removeScenarioItem.addActionListener(this);
            actionMenu.add(this.m_removeScenarioItem);
        }
        actionMenu.addSeparator();
        this.m_saveScenarioToLocaItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuSaveScenarioToLocalFile_withHK);
        if (this.m_saveScenarioToLocaItem != null) {
            this.m_saveScenarioToLocaItem.addActionListener(this);
            actionMenu.add(this.m_saveScenarioToLocaItem);
        }
        this.m_saveScenarioToRepositoryItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuSaveScenarioToRepository_withHK);
        if (this.m_saveScenarioToRepositoryItem != null) {
            this.m_saveScenarioToRepositoryItem.addActionListener(this);
            actionMenu.add(this.m_saveScenarioToRepositoryItem);
        }
        if (actionMenu != null) {
            actionMenu.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performValidateSelectedItemAction() {
        try {
            try {
                this.m_scenarioCanvasPanel.displayWaitCursor();
                VWSIMPropertyData propertyData = this.m_scenarioCanvasPanel.getPropertyData();
                this.m_scenarioMenuHelper.validateScenario(propertyData);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var3_4 = null;
                this.m_scenarioCanvasPanel.restoreDefaultCursor();
            }
            Object var3_3 = null;
            this.m_scenarioCanvasPanel.restoreDefaultCursor();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.m_scenarioCanvasPanel.restoreDefaultCursor();
            throw throwable;
        }
    }
}

